﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BonusProtection : MonoBehaviour
{

    public pickFlower magicalFlower;
    public Material poussinMaterial;
    public Material lePouvoirDesFleurs;
    public int uneChanceSur = 5;
    public float timeTimer = 5.0f;
    public bool powaaa = false; // active le pouvoir de la fleur

    float timer;
    public bool timerActive = false;
    int nbPoussins = 0;
    List<Texture> texturePoussin = new List<Texture>(); // les textures assignées aux poussins pour ce niveau


    // faire apparaitre la fleur de temps en temps au chargement d'un niveau
    void Start()
    {
        Instantiate(magicalFlower, new Vector3(20,20,20), Quaternion.identity);
        magicalFlower.spawnFlower = this.gameObject;
    }
    
    public void Apparition()
    {
        
        timer = timeTimer;

        int getLucky = Random.Range(0, uneChanceSur-1);
        Debug.Log(getLucky);

        if (getLucky == 0)
        {
            int posX = 0;
            int posZ = 0;

            do { posX = Random.Range(-10, 10); } while (posX < 4 && posX > -4);
            do { posZ = Random.Range(-10, 10); } while (posZ < 4 && posZ > -4);

            Vector3 position = new Vector3(posX, 0.8f, posZ);
            Debug.Log(posX + ", " + posZ);
            Instantiate(magicalFlower, position, Quaternion.identity);
            magicalFlower.spawnFlower = this.gameObject;
        }
    }

    //timer
    void Update()
    {
        if (timerActive)
        {
            timer -= Time.deltaTime;
            if (timer < 0)
            {
                EndPowa();
            }
        }
    }

    //activer le pouvoir de la fleur
    public void Powa()
    {
        foreach (Transform poussin in transform)
        {
            nbPoussins++;
            foreach (Transform childObject in poussin.transform)
            {
                if (childObject.name == "Toon Chick")
                {
                    // stocker l'ancienne texture des poussins
                    texturePoussin.Add(childObject.GetComponent<Renderer>().material.mainTexture);

                    // assigner le matériel spécial
                    childObject.GetComponent<Renderer>().material = lePouvoirDesFleurs;

                }
            }
        }

        timerActive = true;

    }

    //desactiver le pouvoir de la fleur
    void EndPowa()
    {
        nbPoussins = 0;
        foreach (Transform poussin in transform)
        {
            nbPoussins++;
            foreach (Transform childObject in poussin.transform)
            {
                if (childObject.name == "Toon Chick")
                {
                    childObject.GetComponent<Renderer>().material = poussinMaterial;
                    childObject.GetComponent<Renderer>().material.mainTexture = texturePoussin[nbPoussins-1];
                }
            }
        }

        timerActive = false;
        timer = timeTimer;

    }
}
